{************************************************************}
{                                                            }
{   Beispiel fr den Zugriff auf eine Access-Datei mit ADO   }
{   Copyright (c) Elmar Herzog 2001. Version 1.0 Freeware    }
{   http://www.elmarherzog.de - Alle Rechte vorbehalten.     }
{                                                            }
{************************************************************}

unit edit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, comctrls, ToolWin, Buttons;


type
  PFehlerRec = ^TFehlerRec;
  TFehlerRec = record
    Titel: string;
    Text: string;
end;

type
  TEditForm = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    OkButton: TButton;
    AbbrechenButton: TButton;
    Memo: TMemo;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    DSLabel: TLabel;
    procedure OkButtonClick(Sender: TObject);
    procedure AbbrechenButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    function SaveData: Boolean;
    function LoadData: Boolean;
    procedure FormDestroy(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SaveRecord;
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

const
  //Tabelle "Datenbank"
  cSELECT = 'SELECT * FROM Datenbank';
  //MS Access-Driver whlen
  cDSN    = 'Provider=Microsoft.Jet.OLEDB.4.0;Data Source=ado2.mdb;Persist Security Info=False';

var
  EditForm: TEditForm;    //Form
  FehlerStrings: TList;   //TList
  FehlerRec: PFehlerRec;  //Record
  Datensatz: Integer;     //Zhler

implementation

{$R *.DFM}

uses ComObj, ADODB_TLB;

//Wird Ok Button gedrckt, werden die nderungen gespeichert
procedure TEditForm.OkButtonClick(Sender: TObject);
begin
   Screen.Cursor := crSQLWait;  //SQL-Cursor zeigen
   SaveRecord;
   if not SaveData then MessageBox(Handle, 'Die Daten wurden nicht gespeichert!', 'Edit', mb_OK or mb_ICONSTOP);
   Close;
   Screen.Cursor := crDefault;  //"normalen" Mauszeiger
end;

//Abbrechen-Button - Scliessen ohne die nderungen zu speichern
procedure TEditForm.AbbrechenButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TEditForm.FormCreate(Sender: TObject);
begin
  Screen.Cursor := crHourglass;
  FehlerStrings := TList.Create; //TList erzeugen
  Datensatz := 0;                //Zhler Datenstze auf 0
  //Buttons deaktivieren
  SpeedButton2.Enabled := False;
  SpeedButton3.Enabled := False;
  SpeedButton4.Enabled := False;
  SpeedButton5.Enabled := False;
  SpeedButton6.Enabled := False;
end;

//Daten speichern
function TEditForm.SaveData: Boolean;
var
  aRecordSet : _Recordset;
  I: Integer;
  NewRecSet: Boolean;
begin
   Result := False;
   if not FileExists('ado2.mdb') then //Prfen ob Datei existiert
   begin
     MessageBox(Handle, 'Die Datei konnte nicht gespeichert werden!', 'Edit', MB_OK or MB_ICONSTOP);
     Exit;
   end;
  try
    NewRecSet := False;
    aRecordSet := CoRecordset.Create; //Erzeugen
    //ffnen
    aRecordSet.Open(cSELECT, cDSN, adOpenForwardOnly, adLockOptimistic, adOpenForwardOnly);
    try
      I := 0; //Zhler fr Datenstze auf 0
      aRecordSet.MoveFirst; //Ersten Datensatz laden
      repeat
        FehlerRec := FehlerStrings[I];  //TList[X] ins Record kopieren
        //wenn Dateiende erreicht ist, neuen Datensatz hinzufgen
        if (aRecordSet.EOF = True) or (aRecordSet.BOF = True) then
        begin
          aRecordSet.AddNew(EmptyParam, EmptyParam);
          NewRecSet := True;
        end;
       //Prfen, ob Felder leer sind
       if not (aRecordSet.Fields.Count = 2) then Exit;
       if FehlerRec.Titel <> '' then
        aRecordSet.Fields[0].Value := FehlerRec.Titel else aRecordSet.Fields[0].Value := '';
       if FehlerRec.Text <> '' then
        aRecordSet.Fields[1].Value := FehlerRec.Text else aRecordSet.Fields[1].Value := '';
       aRecordSet.Move(1, EmptyParam);
       Inc(I);
      until (FehlerStrings.Count -1 < I); //Solange bis alle Datenstze in der Access-Datei bernommen sind
      //solange bis Dateieende erreicht ist, Datenstze lschen
      while (aRecordSet.EOF = False) do
      begin
        if NewRecSet = True then Break;
        aRecordSet.Delete(1);
        aRecordSet.Move(1, EmptyParam);
      end;
       Result := True;
    finally
      aRecordSet.Close; //Schnittstelle schliessen
    end;
  except
    MessageBox(Handle, 'Beim Schreiben der Microsoft-Access-Datei ist ein Fehler aufgetreten.', 'Edit', mb_OK or mb_ICONSTOP);
  end;
end;

//Laden - Einfach nur alle Datenstze der Access-Datei in die TList einfgen
function TEditForm.LoadData: Boolean;
var
  vRecordSet : OleVariant;
begin
  Result := False;
  if not FileExists('ado2.mdb') then Exit;
  try
     vRecordSet := CreateOleObject('ADODB.Recordset');
     vRecordSet.Open(cSelect, cDSN);
    try
      if not (vRecordSet.Fields.Count = 2) then Exit;
      if vRecordSet.EOF then Exit;
      repeat
        New(FehlerRec);
        if vRecordSet.Fields[0].ActualSize <> 0 then
          FehlerRec.Titel := vRecordSet.Fields[0].Value else FehlerRec.Titel := '';
        if vRecordSet.Fields[1].ActualSize <> 0 then
         FehlerRec.Text := vRecordSet.Fields[1].Value else FehlerRec.Text := '';
        FehlerStrings.Add(FehlerRec);
        vRecordSet.Move(1);
      until vRecordSet.EOF;
      Result := True;
    finally
      vRecordSet.Close;
    end;
    except
     MessageBox(Handle, 'Beim ffnen der Microsoft-Access-Datei ist ein Fehler aufgetreten.', 'Edit', mb_OK or mb_ICONSTOP);
  end;
end;

//Programm wird geschlossen (immer)
procedure TEditForm.FormDestroy(Sender: TObject);
begin
  FehlerStrings.Destroy;  //TList wieder fereigeben
  Dispose(FehlerRec);     //Record wieder freigeben
  Screen.Cursor := crDefault;
end;

//Neuen Datensatz hinzufgen
procedure TEditForm.SpeedButton1Click(Sender: TObject);
begin
  Screen.Cursor := crHourglass;
  SaveRecord;
  Inc(Datensatz);
  Edit1.Text := 'Neuer Titel';  //Standard-Titel
  Memo.Text := 'Neuer Fehlertext'; //Standard-Text
  New(FehlerRec);               //Neues Record
  FehlerRec.Titel := Edit1.Text;
  FehlerRec.Text := Memo.Text;
  FehlerStrings.Insert(Datensatz, FehlerRec); //Record in TList einfgen
  if Datensatz = FehlerStrings.Count -1 then
  begin
    if SpeedButton5.Enabled = True then SpeedButton5.Enabled := False;
    if SpeedButton6.Enabled = True then SpeedButton6.Enabled := False;
  end;
  if SpeedButton2.Enabled = False then SpeedButton2.Enabled := True;
  if SpeedButton3.Enabled = False then SpeedButton3.Enabled := True;
  if SpeedButton4.Enabled = False then SpeedButton4.Enabled := True;
  DSLabel.Caption := Format('%d von %d', [Datensatz + 1, FehlerStrings.Count]); //Label aktuallisieren
  Screen.Cursor := crDefault;
end;

//Lschen - Datensatz aus der Liste lschen
procedure TEditForm.SpeedButton2Click(Sender: TObject);
begin
  if MessageBox(Handle, 'Mchten Sie den ausgewhlten Datensatz lschen?', 'Edit', MB_YESNO OR MB_ICONQUESTION) = mrYes then
  begin
    Screen.Cursor := crHourglass;
    FehlerStrings.Delete(Datensatz);
    Dec(Datensatz);

    if FehlerStrings.Count = 1 then
    begin
      if SpeedButton5.Enabled = True then SpeedButton5.Enabled := False;
      if SpeedButton6.Enabled = True then SpeedButton6.Enabled := False;
      if SpeedButton3.Enabled = True then SpeedButton3.Enabled := False;
      if SpeedButton4.Enabled = True then SpeedButton4.Enabled := False;
      SpeedButton2.Enabled := False;
      if Datensatz < 0 then Inc(Datensatz);
    end;

    if Datensatz = FehlerStrings.Count then
    begin
      if SpeedButton5.Enabled = True then SpeedButton5.Enabled := False;
      if SpeedButton6.Enabled = True then SpeedButton6.Enabled := False;
      if Datensatz > 1 then Dec(Datensatz);
    end;

    if Datensatz <= 0 then
    begin
      if SpeedButton4.Enabled = True then SpeedButton4.Enabled := False;
      if SpeedButton3.Enabled = True then SpeedButton3.Enabled := False;
      If Datensatz < 0 then Inc(Datensatz);
    end;

    FehlerRec := FehlerStrings.Items[Datensatz];
    Edit1.Text := FehlerRec.Titel;
    Memo.Text := FehlerRec.Text;
    DSLabel.Caption := Format('%d von %d', [Datensatz + 1, FehlerStrings.Count]);
    Screen.Cursor := crDefault;
  end;
end;

//Zum Anfang der Liste
procedure TEditForm.SpeedButton3Click(Sender: TObject);
begin
  Screen.Cursor := crHourglass;
  SaveRecord;
  Datensatz := 0;
  DSLabel.Caption := Format('%d von %d', [Datensatz + 1, FehlerStrings.Count]);
  FehlerRec := FehlerStrings.Items[Datensatz];
  Edit1.Text := FehlerRec.Titel;
  Memo.Text := FehlerRec.Text;
  if SpeedButton5.Enabled = False then SpeedButton5.Enabled := True;
  if SpeedButton6.Enabled = False then SpeedButton6.Enabled := True;
  if Datensatz = 0 then
  begin
    SpeedButton3.Enabled := False;
    SpeedButton4.Enabled := False;
  end;
  Screen.Cursor := crDefault;
end;

//Nchsten Datensatz
procedure TEditForm.SpeedButton4Click(Sender: TObject);
begin
  Screen.Cursor := crHourglass;
  SaveRecord;
  Dec(Datensatz);
  DSLabel.Caption := Format('%d von %d', [Datensatz + 1, FehlerStrings.Count]);
  FehlerRec := FehlerStrings.Items[Datensatz];
  Edit1.Text := FehlerRec.Titel;
  Memo.Text := FehlerRec.Text;
  if SpeedButton5.Enabled = False then SpeedButton5.Enabled := True;
  if SpeedButton6.Enabled = False then SpeedButton6.Enabled := True;
  if Datensatz = 0 then
  begin
    SpeedButton3.Enabled := False;
    SpeedButton4.Enabled := False;
  end;
  Screen.Cursor := crDefault;
end;

//Einen Datensatz zurck
procedure TEditForm.SpeedButton5Click(Sender: TObject);
begin
  Screen.Cursor := crHourglass;
  SaveRecord;
  Inc(Datensatz);
  DSLabel.Caption := Format('%d von %d', [Datensatz + 1, FehlerStrings.Count]);
  FehlerRec := FehlerStrings.Items[Datensatz];
  Edit1.Text := FehlerRec.Titel;
  Memo.Text := FehlerRec.Text;
  if SpeedButton3.Enabled = False then SpeedButton3.Enabled := True;
  if SpeedButton4.Enabled = False then SpeedButton4.Enabled := True;
  if Datensatz = FehlerStrings.Count -1 then
  begin
    SpeedButton5.Enabled := False;
    SpeedButton6.Enabled := False;
  end;
  Screen.Cursor := crDefault;
end;

//Letzten Datensatz anzeigen
procedure TEditForm.SpeedButton6Click(Sender: TObject);
begin
  Screen.Cursor := crHourglass;
  SaveRecord;
  Datensatz := FehlerStrings.Count - 1;
  DSLabel.Caption := Format('%d von %d', [Datensatz + 1, FehlerStrings.Count]);
  FehlerRec := FehlerStrings.Items[Datensatz];
  Edit1.Text := FehlerRec.Titel;
  Memo.Text := FehlerRec.Text;
  if SpeedButton3.Enabled = False then SpeedButton3.Enabled := True;
  if SpeedButton4.Enabled = False then SpeedButton4.Enabled := True;
  if Datensatz = FehlerStrings.Count -1 then
  begin
    SpeedButton5.Enabled := False;
    SpeedButton6.Enabled := False;
  end;
  Screen.Cursor := crDefault;
end;

procedure TEditForm.FormShow(Sender: TObject);
begin
  Screen.Cursor := crSQLWait;
  //Wenn das Laden der Daten fehlschlgt, dann einen Standard-Datensatz anzeigen
  if not LoadData then
  begin
    MessageBox(Handle, 'Die Daten konnten nicht geladen werden!', 'Edit', mb_OK or MB_ICONSTOP);
    Edit1.Text := '[Neuer Titel]';
    Memo.Text := '[Neuer Fehlertext]';
    New(FehlerRec);
    FehlerRec.Titel := Edit1.Text;
    FehlerRec.Text := Memo.Text;
    FehlerStrings.Add(FehlerRec);
  end;
  Screen.Cursor := crHourglass;
  DSLabel.Caption := Format('%d von %d', [1, FehlerStrings.Count]);
  FehlerRec := FehlerStrings.First;
  Edit1.Text := FehlerRec.Titel;
  Memo.Text := FehlerRec.Text;
  if FehlerStrings.Count > 1 then
  begin
    SpeedButton2.Enabled := True;
    SpeedButton5.Enabled := True;
    SpeedButton6.Enabled := True;
  end;
  Screen.Cursor := crDefault;
end;

//SaveRecord wir immmer aufgerufen, damit die nderung bernommen
//werden kann. z.B. Datensatz wird gendert und der Anwender klickt
//zum nchsten Datensatz. Bevor der neue angezeigt wird, wird der aktuelle
//"aktualisiert".
procedure TEditForm.SaveRecord;
begin
  FehlerRec.Titel := Edit1.Text;
  FehlerRec.Text := Memo.Text;
  FehlerStrings.Items[Datensatz] := FehlerRec;
end;

end.

