{************************************************************}
{                                                            }
{   Beispiel fr den Zugriff auf eine Access-Datei mit ADO   }
{   Copyright (c) Elmar Herzog 2001. Version 1.0 Freeware    }
{   http://www.elmarherzog.de - Alle Rechte vorbehalten.     }
{                                                            }
{************************************************************}

unit form;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    EditNewValue: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure StringGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure EditNewValueKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses ADODB_TLB, ComObj;

const
  cSELECT = 'SELECT * FROM Beispiel'; //Tabelle auswhlen
  //Treiber und Datei whlen
  cDSN    = 'Provider=Microsoft.Jet.OLEDB.4.0;Data Source=ado1.mdb;Persist Security Info=False';

procedure TForm1.FormCreate(Sender: TObject);
var 
  vRecordSet : OleVariant;
  iRow, iCol : Integer;
begin
  //OleObject erzeugen
  vRecordSet := CreateOleObject('ADODB.Recordset');
  //ffnen
  vRecordSet.Open(cSELECT, cDSN);
  iRow := 1;
  repeat
    for iCol := 0 to 2 do
      //Recordfelder dem TStringGird zuweisen
      StringGrid1.Cells[iCol, iRow] :=  vRecordSet.Fields[iCol].Value;
      //RecordSet (Datensatz) um eins erhhen
      vRecordSet.Move(1);
      Inc(iRow);
  until vRecordSet.EOF; //solange bis Dateiende erreicht ist
  vRecordSet.Close;
end;

//Speichern erfolgt wie laden
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var 
  aRecordSet : _Recordset;
  iRow, iCol : Integer;
begin
  aRecordSet := CoRecordset.Create;
  aRecordSet.Open(cSELECT, cDSN, adOpenForwardOnly, adLockOptimistic, adOpenForwardOnly);
  aRecordSet.MoveFirst;
  iRow := 1;
  repeat
    for iCol := 1 to 2 do
     aRecordSet.Fields[iCol].Value := StringGrid1.Cells[iCol, iRow];
     aRecordSet.Move(1, EmptyParam);
     Inc(iRow);
  until (iRow > 3); //drei Durchlufe ausfhren
  aRecordSet.Close;
end;

//Wird eine Zelle ausgewhlt, dann in Edit-Leiste anzeigen
procedure TForm1.StringGrid1SelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
  EditNewValue.Text := StringGrid1.Cells[ACOl, ARow];
end;

//Bei nderung (Enter) Zellen anpassen
procedure TForm1.EditNewValueKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  StringGrid1.Cells[StringGrid1.Col, StringGrid1.Row] := EditNewValue.Text;
end;

//Schliessen
procedure TForm1.Button1Click(Sender: TObject);
begin
  Close
end;

end.
