{*******************************************************}
{                                                       }
{       Delphi Runtime Library                          }
{       DotNetVer32 API Interface Unit                  }
{                                                       }
{       Copyright (c) 2019, Elmar Herzog                }
{                                                       }
{*******************************************************}

unit dotnetver;

{$MINENUMSIZE 4}

interface

uses Windows;

const
  DotNetVerLib = 'dotnetver.dll';

{---------------------------------------------------------------------------}
{ QueryDotNetVersion                                                        }
{---------------------------------------------------------------------------}

{
  * Funktion:     QueryDotNetVersion
  * Beschreibung: Ermittelt alle installierten Version.
  * Parameter:    lpDotNetVersion     - Puffer
                  dwDotNetVersionSize - Puffergre
                  dwReturnLength      - Gesamtlnge des Puffers (optinal)
  * Rckgabe:     ERROR_SUCCESS oder Windows-Fehlercode
                  ERROR_FILE_NOT_FOUND - Keine Versionen gefunden
                  ERROR_MORE_DATA      - Es sind noch weitere Daten vorhanden
}

type
  _DOTNET_VERSION_INFOA = packed record
    dwNextEntryOffset: DWORD;  // Position des nchsten Records; bei 0 = keine weiteren Records
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwServicePack: DWORD;
    dwRelease: DWORD;
    dwFullInstall: DWORD;     // 1 = Client; 2 = Full
    dwVersionLength: DWORD;   // Lnge des Strings in "szVersion"
    szVersion: array[0..0] of AnsiChar;
  end;
  DOTNET_VERSION_INFOA = _DOTNET_VERSION_INFOA;
  LPDOTNET_VERSION_INFOA = ^_DOTNET_VERSION_INFOA;

  _DOTNET_VERSION_INFOW = packed record
    dwNextEntryOffset: DWORD;  // Position des nchsten Records; bei 0 = keine weiteren Records
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwServicePack: DWORD;
    dwRelease: DWORD;
    dwFullInstall: DWORD;      // 1 = Client; 2 = Full
    dwVersionLength: DWORD;    // Lnge des Strings in "szVersion"
    szVersion: array[0..0] of WideChar;
  end;
  DOTNET_VERSION_INFOW = _DOTNET_VERSION_INFOW;
  LPDOTNET_VERSION_INFOW = ^_DOTNET_VERSION_INFOW;

{$IFDEF UNICODE}
  DOTNET_VERSION_INFO = DOTNET_VERSION_INFOW;
  LPDOTNET_VERSION_INFO = LPDOTNET_VERSION_INFOW;
{$ELSE}
  DOTNET_VERSION_INFO = DOTNET_VERSION_INFOA;
  LPDOTNET_VERSION_INFO = LPDOTNET_VERSION_INFOA;
{$ENDIF}

function QueryDotNetVersionA(lpDotNetVersion: LPDOTNET_VERSION_INFOA;
  dwDotNetVersionSize: DWORD; dwReturnLength: PDWORD): DWORD; stdcall;

function QueryDotNetVersionW(lpDotNetVersion: LPDOTNET_VERSION_INFOW;
  dwDotNetVersionSize: DWORD; dwReturnLength: PDWORD): DWORD; stdcall;

{$IFDEF UNICODE}
function QueryDotNetVersion(lpDotNetVersion: LPDOTNET_VERSION_INFOW;
  dwDotNetVersionSize: DWORD; dwReturnLength: PDWORD): DWORD; stdcall;
{$ELSE}
function QueryDotNetVersion(lpDotNetVersion: LPDOTNET_VERSION_INFOA;
  dwDotNetVersionSize: DWORD; dwReturnLength: PDWORD): DWORD; stdcall;
{$ENDIF}


{---------------------------------------------------------------------------}
{ DLL version info                                                          }
{---------------------------------------------------------------------------}

{
  * Funktion:     DllGetVersion
  * Beschreibung: Gibt die Versionsinformationen der DLL (DotNetVer.DLL) zurck.
  * Parameter:    Struktur "DLLVERSIONINFO"
  * Rckgabe:     S_OK oder Fehlercode
}

type
  DllVersionInfo = record
    cbSize: DWORD;
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwPlatformID: DWORD;
  end;
  LPDLLVERSIONINFO = ^DllVersionInfo;
  TDllVersionInfo = DllVersionInfo;

function DllGetVersion(pdvi: LPDLLVERSIONINFO): HRESULT; stdcall;

implementation

function QueryDotNetVersionA;    external DotNetVerLib name 'QueryDotNetVersionA';
function QueryDotNetVersionW;    external DotNetVerLib name 'QueryDotNetVersionW';
function DllGetVersion;          external DotNetVerLib name 'DllGetVersion';

{$IFDEF UNICODE}
function QueryDotNetVersion;    external DotNetVerLib name 'QueryDotNetVersionW';
{$ELSE}
function QueryDotNetVersion;    external DotNetVerLib name 'QueryDotNetVersionA';
{$ENDIF}

end.
