{*******************************************************}
{                                                       }
{       Hauptfenster - Demo der GZIP-Funktionen         }
{       Datum: 20.10.2011                               }
{                                                       }
{       Copyright (c) 2011 Elmar Herzog                 }
{                                                       }
{*******************************************************}

unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls;

type
  TGZIPForm = class(TForm)
    BitBtnNew: TBitBtn;
    BitBtnOpen: TBitBtn;
    BitBtnClose: TBitBtn;
    ProgressBar: TProgressBar;
    StatusLabel: TLabel;
    OpenDialog: TOpenDialog;
    procedure BitBtnNewClick(Sender: TObject);
    procedure BitBtnOpenClick(Sender: TObject);
    procedure BitBtnCloseClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  GZIPForm: TGZIPForm;

implementation

uses Pack, UnPack;

{$R *.DFM}

procedure TGZIPForm.BitBtnNewClick(Sender: TObject);
begin
  //Neue GZIP-Datei erstellen (packen)
  //Nutzung der DLL-Funktionen
  //Unit "pack.pas"
  with OpenDialog do
  begin
    Filter := 'Alle Dateien (*.*)|*.*';
    Options := [ofFileMustExist, ofPathMustExist, ofNoNetworkButton];
  end;
  if OpenDialog.Execute then
  begin
    if gzip_pack(OpenDialog.FileName) then MessageBox(Handle, PChar(Format('Datei %s erfolreich komprimiert.', [OpenDialog.FileName])), PChar('GZIP-Demo'), MB_OK or MB_ICONINFORMATION) else
    MessageBox(Handle, PChar(Format('Datei %s konnte nicht komprimiert werden', [OpenDialog.FileName])), PChar('GZIP-Demo'), MB_OK or MB_ICONERROR);
  end;
end;

procedure TGZIPForm.BitBtnOpenClick(Sender: TObject);
begin
  //Vorhandene GZIP-Datei ffnen und extrahieren
  //Nutzung der Unit (gzip.pas)
  with OpenDialog do
  begin
    Filter := 'GZIP-Dateien (*.gz)|*.gz';
    Options := [ofFileMustExist, ofPathMustExist, ofNoNetworkButton];
  end;
  if OpenDialog.Execute then
  begin
    if gzip_unpack(OpenDialog.FileName) then MessageBox(Handle, PChar(Format('Datei %s erfolreich dekomprimiert.', [OpenDialog.FileName])), PChar('GZIP-Demo'), MB_OK or MB_ICONINFORMATION) else
    MessageBox(Handle, PChar(Format('Datei %s konnte nicht dekomprimiert werden.', [OpenDialog.FileName])), PChar('GZIP-Demo'), MB_OK or MB_ICONERROR);
  end;
end;

procedure TGZIPForm.BitBtnCloseClick(Sender: TObject);
begin
  //Programm Beenden
  Close;
end;

end.
