{*******************************************************}
{                                                       }
{       GZIP DLL Import Unit (wgzip32.dll)              }
{       Datum: 20.10.2011                               }
{                                                       }
{       Copyright (c) 2011 Elmar Herzog                 }
{                                                       }
{*******************************************************}


unit wgzip32;

interface

uses Windows;

const
  Z_MAX_Name    = 79;
  Z_MAX_Comment = 254;

  Z_OK            = 0;
  Z_STREAM_END    = 1;
  Z_ERRNO         = (-1);
  Z_STREAM_ERROR  = (-2);
  Z_DATA_ERROR    = (-3);
  Z_MEM_ERROR     = (-4);
  Z_BUF_ERROR     = (-5);
  Z_VERSION_ERROR = (-6);

  Z_FILE_WRITE_ERROR = (-10);  //Fehler beim Schreiben der Datei
  Z_FILE_SIZE_LIMIT  = (-11);  //Maximale Dateigre berschritten


type
  PgzStream = Pointer; // Zeiger auf die GZIP-Struktur

//GZIP-Funktionen (Pointer)
function gzip_open(filename: PChar; mode: LongWord): PgzStream; stdcall;
function gzip_GetParams(gz: PgzStream; FileName: PChar; LenToFileName: LongWord; Comment: PChar; LenToComment: LongWord;
                        var DateTime: LongWord; var Compress: Byte; var LenOfFileName: LongWord; var LenOfComment: LongWord): Boolean; stdcall;
function gzip_SetParams(gz: PgzStream; FileName: PChar; Comment: PChar; DateTime: LongWord; Compress: Byte): Boolean; stdcall;
function gzip_read(gz: PgzStream; var outBuffer; Len: Integer): Integer; stdcall;
function gzip_write(gz: PgzStream; const inBuffer; Len: Integer): Integer; stdcall;
function gzip_progress(gz: PgzStream): LongWord; stdcall;
function gzip_GetErrorCode(gz: PgzStream): Integer; stdcall;
function gzip_close(var gz: PgzStream): Integer; stdcall;
function gzip_GetVersion(Version: PChar; Len: LongWord): Integer; stdcall;

function gzip_decompress(Wnd: HWND; inFile: PChar; outDir: PChar; Progress: Boolean): Integer; stdcall;
function gzip_compress(Wnd: HWND; inFile: PChar; outDir: PChar; Progress: Boolean): Integer; stdcall;

//Hilfsfunktionen
function gzip_StrGetVersion: string;
procedure gzip_StrGetParams(gz: PgzStream; out FileName: string; out Comment: string; out DateTime: LongWord; out Compress: Byte);

implementation

//Statisches Laden der DLL-Funktionen
function gzip_open(filename: PChar; mode: LongWord): PgzStream; stdcall; external 'wgzip32.dll';
function gzip_GetParams(gz: PgzStream; FileName: PChar; LenToFileName: LongWord; Comment: PChar; LenToComment: LongWord;
                        var DateTime: LongWord; var Compress: Byte; var LenOfFileName: LongWord; var LenOfComment: LongWord): Boolean; stdcall; external 'wgzip32.dll';
function gzip_SetParams(gz: PgzStream; FileName: PChar; Comment: PChar; DateTime: LongWord; Compress: Byte): Boolean; stdcall; external 'wgzip32.dll';
function gzip_read(gz: PgzStream; var outBuffer; Len: Integer): Integer; stdcall; external 'wgzip32.dll';
function gzip_write(gz: PgzStream; const inBuffer; Len: Integer): Integer; stdcall; external 'wgzip32.dll';
function gzip_progress(gz: PgzStream): LongWord; stdcall; external 'wgzip32.dll';
function gzip_GetErrorCode(gz: PgzStream): Integer; stdcall; external 'wgzip32.dll';
function gzip_close(var gz: PgzStream): Integer; stdcall; external 'wgzip32.dll';
function gzip_GetVersion(Version: PChar; Len: LongWord): Integer; stdcall; external 'wgzip32.dll';

function gzip_decompress(Wnd: HWND; inFile: PChar; outDir: PChar; Progress: Boolean): Integer; stdcall; external 'wgzip32.dll';
function gzip_compress(Wnd: HWND; inFile: PChar; outDir: PChar; Progress: Boolean): Integer; stdcall; external 'wgzip32.dll';

//Version als String zurckgeben
function gzip_StrGetVersion: string;
var
  Len: Integer;
  Buffer: PChar;
begin
  Result := '';
  Len := gzip_GetVersion(nil, 0);
  if (Len > 0) then
  begin
    GetMem(Buffer, Len + 1);
    try
      gzip_GetVersion(Buffer, Len + 1);
      Result := Buffer;
    finally
      FreeMem(Buffer);
    end;
  end;
end;

//Zusatzdaten ermitteln
procedure gzip_StrGetParams(gz: PgzStream; out FileName: string; out Comment: string; out DateTime: LongWord; out Compress: Byte);
var
  PFileName, PComment: PChar;
  LenToFileName, LenToComment, LenOfFileName, LenOfComment: LongWord;
begin
  FileName := '';
  Comment := '';
  DateTime := 0;
  Compress := 0;
  if Assigned(gz) then
  begin
    if not gzip_GetParams(gz, nil, 0, nil, 0, DateTime, Compress, LenToFileName, LenToComment) then Exit;
    GetMem(PFileName, LenToFileName + 1);
    try
      GetMem(PComment, LenToComment + 1);
      try
        gzip_GetParams(gz, PFileName, LenToFileName +1, PComment, LenToComment + 1, DateTime, Compress, LenOfFileName, LenOfComment);
        FileName := PFileName;
        Comment := PComment;
      finally
        FreeMem(PComment);
      end;
    finally
      FreeMem(PFileName);
    end;
  end;
end;

end.
