{*******************************************************}
{                                                       }
{       Datei ffnen und GZIP-Datei erstellen           }
{       Datum: 20.10.2011                               }
{                                                       }
{       Copyright (c) 2011 Elmar Herzog                 }
{                                                       }
{*******************************************************}

unit pack;

interface

function gzip_pack(FileName: string): Boolean;

implementation

uses Windows, Forms, MainForm, SysUtils, Classes, wgzip32;

function gzip_pack(FileName: string): Boolean;
var
  gzipFile: string;
  inFile: Integer;
  gz: PgzStream;
  Buffer: Array [Word] of Char;
  count: Integer;
  I64: Int64;
  I32: LongWord;
begin
  Result := False;
  gzipFile := FileName + '.gz';

  inFile := FileOpen(FileName, fmOpenRead);
  if (inFile > 0) then
  begin
    try
      //Staus Label
      GZIPForm.StatusLabel.Caption := Format('Datei %s wird komprimiert.', [FileName]);
      //ProgressBar
      I64 := (FileSeek(inFile, int64(0), 2) );
      if (I64 > High(LongWord)) then Exit;

      GZIPForm.ProgressBar.Max := (I64 div 2);
      FileSeek(inFile, 0, 0);

      gz := gzip_open(PChar(gzipFile), fmCreate);
      if (gz <> nil) then
      begin
        try
          if not gzip_SetParams(gz, PChar(ExtractFileName(FileName)), PChar(''), 0, 0) then Exit;
          repeat
            FillChar(Buffer, sizeOf(Buffer), #0);
            count := FileRead(inFile, Buffer, sizeof(Buffer));
            if (count > 0) then
            begin
               if (gzip_write(gz, Buffer, Count) <> count) then Break;
            end;
            //ProgressBar
            I32 := gzip_progress(gz);
            GZIPForm.ProgressBar.Position := (I32 div 2);
            Application.ProcessMessages;
          until (count <= 0) or (gzip_GetErrorCode(gz) <> 0);
          Result := True;
        finally
          if not gzip_close(gz) = 0 then Result := False;
        end;
      end;
    finally
      FileClose(inFile);
    end;
  end;
end;

end.
