{*******************************************************}
{                                                       }
{       GZIP-Datei ffnen und Datei dekomprimieren      }
{       Datum: 20.10.2011                               }
{                                                       }
{       Copyright (c) 2011 Elmar Herzog                 }
{                                                       }
{*******************************************************}

unit unpack;

interface

function gzip_unpack(FileName: string): Boolean;

implementation

uses Windows, Forms, MainForm, SysUtils {$IFDEF VER130}, gzip {$ELSE}, wgzip32 {$ENDIF};

{$IFDEF VER130}
//Delphi 5
function gzip_unpack(FileName: string): Boolean;
var
  gz: PgzStream;
  outFile: Integer;
  outName: string;
  count: Integer;
  Buffer: Array [Word] of Char;
  I32: Cardinal;
begin
  Result := False;

  gz := gzip_open(PChar(FileName), fmOpenRead);
  if Assigned(gz) then
  begin
    try
      if (gz.Name <> '') then outName := gz.Name else
      outName := ChangeFileExt(FileName, '');
      //Staus Label
      GZIPForm.StatusLabel.Caption := Format('Datei %s wird dekomprimiert.', [FileName]);
      //ProgressBar
      GZIPForm.ProgressBar.Max := gz.inSize div 2;

      if FileExists(outName) then Exit;
      outFile := FileCreate(outName);
      if (outFile > 0) then
      begin
        try
          FileSeek(outFile, 0, 0);
          repeat
            FillChar(Buffer, sizeOf(Buffer), #0);
            count := gzip_read(gz, Buffer, sizeOf(Buffer));
            if (count > 0) then
            begin
              if (FileWrite(outFile, Buffer, count) <> count) then Exit;
            end;
            //ProgressBar
            I32 := gzip_progress(gz);
            GZIPForm.ProgressBar.Position := (I32 div 2);
            Application.ProcessMessages;
          until (count <= 0) or (gzip_GetErrorCode(gz) <> Z_OK);
        finally
          FileClose(outFile);
        end;
      end;
    finally
      if (gzip_close(gz) = Z_OK) then Result := True;
    end;
  end;
end;

{$ELSE}
//Alle anderen Versionen
function gzip_unpack(FileName: string): Boolean;
begin
  if (gzip_decompress(GZIPForm.ProgressBar.Handle, PChar(FileName), PChar(ExtractFileDir(FileName)), True) = Z_OK) then
    Result := True
  else
    Result := False;
end;

{$ENDIF}

end.

