{*******************************************************}
{                                                       }
{       Delphi Runtime Library                          }
{       WinEx API Interface Unit                        }
{                                                       }
{       Copyright (c) 2016, Elmar Herzog                }
{                                                       }
{*******************************************************}


unit WinEx;

{$MINENUMSIZE 4}

interface

uses Windows;

const
  WinExLib = 'WinEx.dll';

{---------------------------------------------------------------------------}
{ Version / Ausgabe 1                                                       }
{---------------------------------------------------------------------------}

{
  * Funktion:     CheckMsDosModus
  * Beschreibung: Ermittelt ob bei Windows 9x in den MS-DOS-Modus
  *               gewechselt werden kann.
  * Rckgabe:     TRUE oder FALSE
}
function CheckMsDosModus: ByteBool; stdcall;


{
  * Funktion:     CheckSystemPowerStatus
  * Beschreibung: berprft ob die Energiesparfunktionen (S1-S3) auf dem
  *               Gert bereit stehen.
  * Rckgabe:     TRUE oder FALSE
}
function CheckSystemPowerStatus: ByteBool; stdcall;


{
  * Funktion:     CheckUserName
  * Beschreibung: berprft ob ein Benutzer am System angemeldet ist.
  * Rckgabe:     TRUE oder FALSE
}
function CheckUserName: ByteBool; stdcall;


{
  * Funktion:     CheckWindowsNT
  * Beschreibung: berprft ob es um ein Windows NT-System handelt.
  *               (alle Systeme auer Windows 9x/ME)
  *               Fr detaillierte Informationen zum System muss die
  *               Windows-API verwendet werden.
  * Rckgabe:     TRUE oder FALSE
}
function CheckWindowsNT: ByteBool; stdcall;


{
  * Funktion:     WindowsNTPrivilegien
  * Beschreibung: Setzt fr den aktuellen Prozess die Benutzerrechte
  *               damit dieser das System beenden kann.
  * Hinweis:      Diese Funktion ist aus Kompatibilittsgrnden noch
  *               enthalten.
  * Rckgabe:     TRUE oder FALSE
}
function WindowsNTPrivilegien: ByteBool; stdcall;



{
  * Funktion:     WindowsForceLogOnOff
  * Beschreibung: Der aktuelle Benutzer wird abgemeldet. Der Vorgang wird
  *               erzwungen. Nicht gespeicherte Daten gehen ggf. verloren.
  * Rckgabe:     TRUE oder FALSE
}
function WindowsForceLogOnOff: ByteBool; stdcall;


{
  * Funktion:     WindowsForceReboot
  * Beschreibung: Startet Windows neu. Der Vorgang wird erzwungen.
  *               Nicht gespeicherte Daten gehen ggf. verloren.
  * Rckgabe:     TRUE oder FALSE
}
function WindowsForceReboot: ByteBool; stdcall;


{
  * Funktion:     WindowsForceShutdown
  * Beschreibung: Windows wird heruntergefahren. Der Vorgang wird erzwungen.
  *               Nicht gespeicherte Daten gehen ggf. verloren.
  * Rckgabe:     TRUE oder FALSE
}
function WindowsForceShutdown: ByteBool; stdcall;


{
  * Funktion:     WindowsLogOnOff
  * Beschreibung: Der aktuelle Benutzer wird abgemeldet (Sitzung beenden).
  *               Alle Anwendungen werden benachrichtigt und knnen den
  *               Vorgang abbrechen.
  * Rckgabe:     TRUE oder FALSE
}
function WindowsLogOnOff: ByteBool; stdcall;


{
  * Funktion:      WindowsMsDosModus
  * Beschreibung:  Wechselt bei Windows 9x in den MS-DOS-Modus.
  * Rckgabe:      TRUE oder FALSE
}
function WindowsMsDosModus: ByteBool; stdcall;


{
  * Funktion:     WindowsReboot
  * Beschreibung: Startet Windows neu. Alle Anwendungen werden benachrichtigt
                  und knnen den Vorgang abbrechen.
  * Rckgabe:     TRUE oder FALSE
}
function WindowsReboot: ByteBool; stdcall;


{
  * Funktion:     WindowsShutdown
  * Beschreibung: Windows wird heruntergefahren. Alle Anwendungen werden
  *               benachrichtigt und knnen den Vorgang abbrechen.
  * Rckgabe:     TRUE oder FALSE
}
function WindowsShutdown: ByteBool; stdcall;


{
  * Funktion:     WindowsStandby
  * Beschreibung: Wechselt in den Energiesparmodus (Standby)
  * Rckgabe:     TRUE oder FALSE
}
function WindowsStandby: ByteBool; stdcall;


{---------------------------------------------------------------------------}
{ Version / Ausgabe 2                                                       }
{---------------------------------------------------------------------------}

{
  * Funktion:     LocalAbortSystemShutdown
  * Beschreibung: Das initiierte Beenden von Windows (Herunterfahren, Neustart)
  *               wird abgebrochen / gestoppt.
  * Minimum:      Windows NT (nicht Windows 9x/ME)
  * Rckgabe:     TRUE oder FALSE
}
function LocalAbortSystemShutdown: BOOL; stdcall;


{
  * Funktion:     LocalInitSystemRebootA, LocalInitSystemRebootW
  * Beschreibung: Der Neustart von Windows wird initiiert. Dem
  *               Benutzer wird eine Benachrichtigung angezeigt.
  * Parameter:    lpMessage       - Nachricht die dem Benutzer angezeigt werden soll.
  *               dwTimeout       - Zeit bis Windows heruntergefahren wird (in Sekunden).
  *               bForceAppsClose - Der Vorgang wird erzwungen.
  * Minimum:      Windows NT (nicht Windows 9x/ME)
  * Rckgabe:     TRUE oder FALSE
}
function LocalInitSystemRebootA(lpMessage: PAnsiChar; dwTimeout: DWORD;
  bForceAppsClose: BOOL): BOOL; stdcall;
function LocalInitSystemRebootW(lpMessage: PWideChar; dwTimeout: DWORD;
  bForceAppsClose: BOOL): BOOL; stdcall;


{
  * Funktion:     LocalInitSystemShutdownA, LocalInitSystemShutdownW
  * Beschreibung: Das Herunterfahren von Windows wird initiiert. Dem
  *               Benutzer wird eine Benachrichtigung angezeigt.
  * Parameter:    lpMessage       - Nachricht die dem Benutzer angezeigt werden soll.
  *               dwTimeout       - Zeit bis Windows heruntergefahren wird (in Sekunden).
  *               bForceAppsClose - Der Vorgang wird erzwungen.
  * Minimum:      Windows NT (nicht Windows 9x/ME)
  * Rckgabe:     TRUE oder FALSE
}
function LocalInitSystemShutdownA(lpMessage: PAnsiChar; dwTimeout: DWORD;
  bForceAppsClose: BOOL): BOOL; stdcall;
function LocalInitSystemShutdownW(lpMessage: PWideChar; dwTimeout: DWORD;
  bForceAppsClose: BOOL): BOOL; stdcall;


{
  * Funktion:     WindowsHibernate
  * Beschreibung: Die Sitzung wird auf dem Datentrger gespeichert
  *               (Ruhezustand; S4).
  * Minimum:      Windows 2000
  * Rckgabe:     TRUE oder FALSE
}
function WindowsHibernate: BOOL; stdcall;


{
  * Funktion:     WindowsHybridShutdown
  * Beschreibung: Windows wird in den hybriden Modus heruntergefahren (sofern
  *               der Modus aktiviert worden ist).
  * Minimum:      Windows 8
  * Hinweis:      Bei allen lteren Systemen oder nicht aktiviertem Modus wird
  *               Windows normal heruntergefahren.
  * Rckgabe:     TRUE oder FALSE
}
function WindowsHybridShutdown: BOOL; stdcall;


{
  * Funktion:     WindowsRestartApps
  * Beschreibung: Der Benutzer wird abgemeldet. Registrierte Anwendungen werden nach dem
  *               Neustart automatisch gestartet.
  * Minimum:      Windows Vista
  * Hinweis:      Bei allen lteren System wird ein normaler Neustart durch-
  *               gefhrt.
  * Windows-API:  RegisterApplicationRestart (Kernel32.dll)
  * Rckgabe:     TRUE oder FALSE
}
function WindowsRestartApps: BOOL; stdcall;



{---------------------------------------------------------------------------}
{ Windows-API                                                               }
{---------------------------------------------------------------------------}


{
  * Funktion:     GetPwrCapabilities
  * Beschreibung: Gibt den aktuellen Status zur Energieverwaltung zurck.
  * Hinweis:      Weitere Informationen in der Windows-SDK.
  * Rckgabe:     TRUE oder FALSE
}
type
  PBatteryReportingScale = ^TBatteryReportingScale;
  BATTERY_REPORTING_SCALE = packed record
    Granularity : DWORD;
    Capacity : DWORD;
  end;
  TBatteryReportingScale = BATTERY_REPORTING_SCALE;
  {$EXTERNALSYM BATTERY_REPORTING_SCALE}
  PBATTERY_REPORTING_SCALE = ^BATTERY_REPORTING_SCALE;
  {$EXTERNALSYM PBATTERY_REPORTING_SCALE}

type
  PSystemPowerState = ^TSystemPowerState;
  _SYSTEM_POWER_STATE = (
    PowerSystemUnspecified,
    PowerSystemWorking,
    PowerSystemSleeping1,
    PowerSystemSleeping2,
    PowerSystemSleeping3,
    PowerSystemHibernate,
    PowerSystemShutdown,
    PowerSystemMaximum);
  {$EXTERNALSYM _SYSTEM_POWER_STATE}
  SYSTEM_POWER_STATE = _SYSTEM_POWER_STATE;
  TSystemPowerState = _SYSTEM_POWER_STATE;
  {$EXTERNALSYM SYSTEM_POWER_STATE}
  PSYSTEM_POWER_STATE = ^_SYSTEM_POWER_STATE;
  {$EXTERNALSYM PSYSTEM_POWER_STATE}

type
  PSystemPowerCapabilities = ^TSystemPowerCapabilities;
  SYSTEM_POWER_CAPABILITIES = packed record
    PowerButtonPresent: ByteBool;
    SleepButtonPresent: ByteBool;
    LidPresent: ByteBool;
    SystemS1: ByteBool;
    SystemS2: ByteBool;
    SystemS3: ByteBool;
    SystemS4: ByteBool;
    SystemS5: ByteBool;
    HiberFilePresent: ByteBool;
    FullWake: ByteBool;
    VideoDimPresent: ByteBool;
    ApmPresent: ByteBool;
    UpsPresent: ByteBool;
    ThermalControl: ByteBool;
    ProcessorThrottle: ByteBool;
    ProcessorMinThrottle: Byte;
    ProcessorMaxThrottle: Byte;
    FastSystemS4: ByteBool;
    HiberBoot: ByteBool;
    WakeAlarmPresent: ByteBool;
    AoAc: ByteBool;
    DiskSpinDown: ByteBool;
    spare3: array[0..7] of Byte;
    SystemBatteriesPresent: ByteBool;
    BatteriesAreShortTerm: ByteBool;
    BatteryScale: array[0..2] of BATTERY_REPORTING_SCALE;
    AcOnLineWake: SYSTEM_POWER_STATE;
    SoftLidWake: SYSTEM_POWER_STATE;
    RtcWake: SYSTEM_POWER_STATE;
    MinDeviceWakeState: SYSTEM_POWER_STATE;
    DefaultLowLatencyWake: SYSTEM_POWER_STATE;
  end;
  TSystemPowerCapabilities = SYSTEM_POWER_CAPABILITIES;
  {$EXTERNALSYM SYSTEM_POWER_CAPABILITIES}
  PSYSTEM_POWER_CAPABILITIES = ^SYSTEM_POWER_CAPABILITIES;
  {$EXTERNALSYM PSYSTEM_POWER_CAPABILITIES}
function GetPwrCapabilities(lpspc: PSYSTEM_POWER_CAPABILITIES): ByteBool; stdcall;
{$EXTERNALSYM GetPwrCapabilities}


{
  * Funktion:     InitiateShutdownA, InitiateShutdownW
  * Beschreibung: Initiiert das Beenden von Windows.
  * Hinweis:      Weitere Informationen in der Windows-SDK.
  *               Privileg "SE_SHUTDOWN_NAME" wird zuvor bentigt!
  *               Abbruch mit der Funktion "AbortSystemShutdown".
  * Minimum:      Windows Vista
  * Rckgabe:     Im Erfolgsfall "ERROR_SUCCESS"
}
const
  SHUTDOWN_FORCE_OTHERS         = $00000001;
  {$EXTERNALSYM SHUTDOWN_FORCE_OTHERS}
  SHUTDOWN_FORCE_SELF           = $00000002;
  {$EXTERNALSYM SHUTDOWN_FORCE_SELF}
  SHUTDOWN_RESTART              = $00000004;
  {$EXTERNALSYM SHUTDOWN_RESTART}
  SHUTDOWN_POWEROFF             = $00000008;
  {$EXTERNALSYM SHUTDOWN_POWEROFF}
  SHUTDOWN_NOREBOOT             = $00000010;
  {$EXTERNALSYM SHUTDOWN_NOREBOOT}
  SHUTDOWN_GRACE_OVERRIDE       = $00000020;
  {$EXTERNALSYM SHUTDOWN_GRACE_OVERRIDE}
  SHUTDOWN_INSTALL_UPDATES      = $00000040;
  {$EXTERNALSYM SHUTDOWN_INSTALL_UPDATES}
  SHUTDOWN_RESTARTAPPS          = $00000080;
  {$EXTERNALSYM SHUTDOWN_RESTARTAPPS}
  SHUTDOWN_HYBRID               = $00000200;
  {$EXTERNALSYM SHUTDOWN_HYBRID}

function InitiateShutdownA(lpMachineName, lpMessage: PAnsiChar;
    dwGracePeriod, dwShutdownFlags, dwReason: DWORD): DWORD; stdcall;
{$EXTERNALSYM InitiateShutdownA}
function InitiateShutdownW(lpMachineName, lpMessage: PWideChar;
    dwGracePeriod, dwShutdownFlags, dwReason: DWORD): DWORD; stdcall;
{$EXTERNALSYM InitiateShutdownW}


{
  * Funktion:     InitiateSystemShutdownExA, InitiateSystemShutdownExW
  * Beschreibung: Initiiert das Herunterfahren oder einen Neustart von Windows
  * Hinweis:      Weitere Informationen in der Windows-SDK.
  *               Privileg "SE_SHUTDOWN_NAME" wird zuvor bentigt!
  *               Abbruch mit der Funktion "AbortSystemShutdown".
  * Minimum:      Windows 2000
  * Rckgabe:     TRUE oder FALSE
}
function InitiateSystemShutdownExA(lpMachineName, lpMessage: PAnsiChar;
  dwTimeout: DWORD; bForceAppsClosed: BOOL; bRebootAfterShutdown: BOOL;
  dwReason: DWORD): BOOL; stdcall;
{$EXTERNALSYM InitiateSystemShutdownExA}
function InitiateSystemShutdownExW(lpMachineName, lpMessage: PWideChar;
  dwTimeout: DWORD; bForceAppsClosed: BOOL; bRebootAfterShutdown: BOOL;
  dwReason: DWORD): BOOL; stdcall;
{$EXTERNALSYM InitiateSystemShutdownExW}


{
  * Funktion:     IsPwrHibernateAllowed
  * Beschreibung: berprft, ob der Ruhezustand (S4) bereit steht.
  * Rckgabe:     TRUE oder FALSE
}
function IsPwrHibernateAllowed: ByteBool; stdcall;
{$EXTERNALSYM IsPwrHibernateAllowed}


{
  * Funktion:     IsPwrSuspendAllowed
  * Beschreibung: berprft, ob der Energiesparmodus (S1-S3) bereit steht.
  * Rckgabe:     TRUE oder FALSE
}
function IsPwrSuspendAllowed: ByteBool; stdcall;
{$EXTERNALSYM IsPwrSuspendAllowed}


{
  * Funktion:     LockWorkStation
  * Beschreibung: Sperrt den Computer.
  * Minimum:      Windows NT (nicht Windows 9x/ME)
  * Rckgabe:     TRUE oder FALSE
}
function LockWorkStation: BOOL; stdcall;
{$EXTERNALSYM LockWorkStation}


{
  * Funktion:     RestartDialog
  * Beschreibung: Zeigt den Neustart-Dialog an.
  * Parameter:    hWnd     - Fensterhandle (oder "0")
  *               lpPrompt - angezeigter Text (sonst "nil")
  *               uFlags   - zustzliche Flags fr Dialogfenster
  * Rckgabe:     Schaltflchen-ID
}
function RestartDialog(hWnd: HWND; lpPrompt: PAnsiChar; uFlags: UINT): Integer; stdcall;

{
  * Funktion:     ShutdownBlockReasonCreate
  * Beschreibung: Zeigt eine Meldung an, wenn das Programm das Herunterfahren
  *               verhindert (Rckgabe WM_QUERYENDSESSION = False).
  * Minimum:      Windows Vista
  * Rckgabe:     TRUE oder FALSE
}
function ShutdownBlockReasonCreate(hWnd: HWND; pwszReason: PWideChar): BOOL; stdcall;
{$EXTERNALSYM ShutdownBlockReasonCreate}


{
  * Funktion:     ShutdownBlockReasonDestroy
  * Beschreibung: Entfernt die Meldung welche mit "ShutdownBlockReasonCreate"
  *               erstellt worden ist.
  * Hinweis:      Weitere Informationen in der Windows-SDK.
  * Minimum:      Windows Vista
  * Rckgabe:     TRUE oder FALSE
}
function ShutdownBlockReasonDestroy(hWnd: HWND): BOOL; stdcall;
{$EXTERNALSYM ShutdownBlockReasonDestroy}


{
  * Funktion:     ShutdownBlockReasonQuery
  * Beschreibung: Ermittelt den gesetzten Text der Funktion "ShutdownBlockReasonCreate"
  * Hinweis:      Weitere Informationen in der Windows-SDK.
  * Minimum:      Windows Vista
  * Rckgabe:     TRUE oder FALSE
}
function ShutdownBlockReasonQuery(hWnd: HWND; pwszBuff: PWideChar;
  pccBuff: PDWORD): BOOL; stdcall;
{$EXTERNALSYM ShutdownBlockReasonQuery}


{
  * Funktion:     ShutdownDialog
  * Beschreibung: Zeigt den Standard-Dialog zum Beenden an.
  * Parameter:    Fensterhandle der Anwendung
  * Rckgabe:     TRUE oder FALSE
}
function ShutdownDialog(hWnd: HWND): BOOL; stdcall;


{
  * Funktion:     SetSuspendState
  * Beschreibung: Wechselt in den Energiesparmodus oder in den Ruhezustand.
  * Hinweis:      Weitere Informationen in der Windows-SDK.
  * Rckgabe:     TRUE oder FALSE
}
function SetSuspendState(bHibernate, bForce,
  bWakeupEventsDisabled: ByteBool): ByteBool; stdcall;
{$EXTERNALSYM SetSuspendState}



{ Translated from WINBASE.H}

{
  * Funktion:     RegisterApplicationRestart
  * Beschreibung: Startet nach einem Neustart die angegebenen Anwendungen.
  * Hinweis:      Weitere Informationen in der Windows-SDK.
  * Rckgabe:     S_OK oder Fehlercode
}

function RegisterApplicationRestart(pwzCommandline: PWideChar;
   dwFlags: DWORD): HRESULT; stdcall;
{$EXTERNALSYM RegisterApplicationRestart}
type
  TRegisterApplicationRestart = function(pwzCommandline: PWideChar;
    dwFlags: DWORD): HRESULT; stdcall;

const
  RESTART_NO_CRASH  = 1;
  {$EXTERNALSYM RESTART_NO_CRASH}
  RESTART_NO_HANG   = 2;
  {$EXTERNALSYM RESTART_NO_HANG}
  RESTART_NO_PATCH  = 4;
  {$EXTERNALSYM RESTART_NO_PATCH}
  RESTART_NO_REBOOT = 8;
  {$EXTERNALSYM RESTART_NO_REBOOT}


{---------------------------------------------------------------------------}
{ DLL version info                                                          }
{---------------------------------------------------------------------------}


{
  * Funktion:     DllGetVersion
  * Beschreibung: Gibt die Versionsinformationen der DLL (WinEx.DLL) zurck.
  * Rckgabe:     S_OK oder Fehlercode
}

type
  PDllVersionInfo = ^TDllVersionInfo;
  _DllVersionInfo = packed record
    cbSize: DWORD;
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwPlatformID: DWORD;
  end;
  {$EXTERNALSYM _DllVersionInfo}
  TDllVersionInfo = _DllVersionInfo;
  DLLVERSIONINFO = ^_DllVersionInfo;
  {$EXTERNALSYM DLLVERSIONINFO}

function DllGetVersion(pdvi: DLLVERSIONINFO): HRESULT; stdcall;


implementation

// Compatibility functions
function CheckMsDosModus;            external WinExLib name 'CheckMsDosModus';
function CheckSystemPowerStatus;     external WinExLib name 'CheckSystemPowerStatus';
function CheckUserName;              external WinExLib name 'CheckUserName';
function CheckWindowsNT;             external WinExLib name 'CheckWindowsNT';
function WindowsNTPrivilegien;       external WinExLib name 'WindowsNTPrivilegien';
// version 1
function WindowsForceLogOnOff;       external WinExLib name 'WindowsForceLogOnOff';
function WindowsForceReboot;         external WinExLib name 'WindowsForceReboot';
function WindowsForceShutdown;       external WinExLib name 'WindowsForceShutdown';
function WindowsLogOnOff;            external WinExLib name 'WindowsLogOnOff';
function WindowsMsDosModus;          external WinExLib name 'WindowsMsDosModus';
function WindowsReboot;              external WinExLib name 'WindowsReboot';
function WindowsShutdown;            external WinExLib name 'WindowsShutdown';
function WindowsStandby;             external WinExLib name 'WindowsStandby';
// version 2
function LocalAbortSystemShutdown;   external WinExLib name 'LocalAbortSystemShutdown';
function LocalInitSystemRebootA;     external WinExLib name 'LocalInitSystemRebootA';
function LocalInitSystemRebootW;     external WinExLib name 'LocalInitSystemRebootW';
function LocalInitSystemShutdownA;   external WinExLib name 'LocalInitSystemShutdownA';
function LocalInitSystemShutdownW;   external WinExLib name 'LocalInitSystemShutdownW';
function WindowsHibernate;           external WinExLib name 'WindowsHibernate';
function WindowsHybridShutdown;      external WinExLib name 'WindowsHybridShutdown';
function WindowsRestartApps;         external WinExLib name 'WindowsRestartApps';
// Win-API
function GetPwrCapabilities;         external WinExLib name 'GetPwrCapabilities';
function InitiateShutdownA;          external WinExLib name 'InitiateShutdownA';
function InitiateShutdownW;          external WinExLib name 'InitiateShutdownW';
function InitiateSystemShutdownExA;  external WinExLib name 'InitiateSystemShutdownExA';
function InitiateSystemShutdownExW;  external WinExLib name 'InitiateSystemShutdownExW';
function IsPwrHibernateAllowed;      external WinExLib name 'IsPwrHibernateAllowed';
function IsPwrSuspendAllowed;        external WinExLib name 'IsPwrSuspendAllowed';
function LockWorkStation;            external WinExLib name 'LockWorkStation';
function RestartDialog;              external WinExLib name 'RestartDialog';
function ShutdownBlockReasonCreate;  external WinExLib name 'ShutdownBlockReasonCreate';
function ShutdownBlockReasonDestroy; external WinExLib name 'ShutdownBlockReasonDestroy';
function ShutdownBlockReasonQuery;   external WinExLib name 'ShutdownBlockReasonQuery';
function ShutdownDialog;             external WinExLib name 'ShutdownDialog';
function SetSuspendState;            external WinExLib name 'SetSuspendState';
// DLL version info
function DllGetVersion;              external WinExLib name 'DllGetVersion';


{ Translated from WINBASE.H}

// Minimum supported client: Windows Vista
function RegisterApplicationRestart(pwzCommandline: PWideChar;
   dwFlags: DWORD): HRESULT; stdcall;
var
  hKernel32: THandle;
  _RegisterApplicationRestart: TRegisterApplicationRestart;
begin
  Result := E_FAIL;
  hKernel32 := LoadLibrary(kernel32);
  if (hKernel32 <> 0) then
  begin
    @_RegisterApplicationRestart := GetProcAddress(hKernel32, 'RegisterApplicationRestart');
    if Assigned(_RegisterApplicationRestart) then
      Result := _RegisterApplicationRestart(pwzCommandline, dwFlags);
    FreeLibrary(hKernel32);
  end;
end;

end.
